
markup.push({


	// -------------------------------------------------
	// MARK: channel tweaker

	ChannelTweakerBlock:
	{
		"+": "BlockTemplate",
		gxTitle: "Channels",
		geNodeClass: "AHChannelTweaker",
		gxPopoverInfo: "ChannelPopover",
		gxLibraryIcon: "library.channels",
		gxLibraryDescription: "Adjust channel settings",
		geImporterParams: ["node.importTweakMode"],
		gxChildViews:
		{
			modeImage: {
				nsClass: "GXDrawView",
				gxForePainter: "ImagePainter",
				gxValueKey: "node.tweakMode",
				gxFormatter: "ChannelsImageFormatter",
				gxFrameRect: "36,32,48,54",
				axIsIgnored: true,
			},
			mode: {
				"+": "BlockPopup.stripMarkup",
				gxValueKey: "node.tweakMode",
				gxMenuItems: "TweakMenuItems",
				axIsIgnored: false,
				axTitle: "Channel action",
			},
		}
	},
	
	// MARK: menu items
	
	TweakMenuItems: [
		menuItem("<menuIcon.channels.tiny.none/> No Change", 0, "useMarkup"),
		menuItem("<menuIcon.channels.tiny.swap/> Swap", 1, "useMarkup"),
		menuItem("<menuIcon.channels.tiny.mono/> Mono", 2, "useMarkup"),
		menuItem("<menuIcon.channels.tiny.duplicate.left/> Copy Left", 3, "useMarkup"),
		menuItem("<menuIcon.channels.tiny.duplicate.right/> Copy Right", 4, "useMarkup"),
		menuItem("<menuIcon.channels.tiny.kill.left/> Kill Left", 5, "useMarkup"),
		menuItem("<menuIcon.channels.tiny.kill.right/> Kill Right", 6, "useMarkup"),
		menuItem("<menuIcon.channels.tiny.invert.left/> Invert Left", 7, "useMarkup"),
		menuItem("<menuIcon.channels.tiny.invert.right/> Invert Right", 8, "useMarkup"),
		menuItem("<menuIcon.channels.tiny.subtract/> Subtract", 9, "useMarkup"),
	],
	
	// MARK: popover

	ChannelPopover:
	{
		"+": "PopoverTemplate",
		gxTitle: "Channel",
		gxCanDrawSubviewsIntoLayer: true,
		gxLayout: [ "H:|-12-[self(300)]-12-|",	// sets popover width
					"V:|-12-[self]-12-|",
					"V:|-41-[group]-16-|"
		],
		gxChildViews:
		{
			title: "PopoverTitle",
			switch: "PopoverOnOffSwitch",
			group: {
				"+": "GroupView.noBottomStroke",
				gxLayout: [
					"H:|-0-[self]-0-|",
						   
					"V:|-16-[mode]-7-[text(38)]-0-|",
					"V:[mode]-18-[infoIcon]",
					
					"H:|-14-[modeLabel]-8-[mode]-14-|&alignBaseline",

					"H:|-14-[infoIcon(16)]-8-[text]-11-|",
				],
				gxChildViews: {
					mode: {
						"+": "PopupMenuTemplate.useMarkup",
						gxValueKey: "node.tweakMode",
						gxMenuItems: "TweakMenuItems",
						axIsIgnored: false,
						axTitle: "Channel action",
					},
					modeLabel: labelView("Action:"),
					infoIcon: { "+": "InfoIcon" },
					text: {
						"+": "DescriptionLabelView.foreColor1.size11.left.wrap.useMarkup",
						gxValueKey: "node.tweakMode",
						gxFormatter: "ChannelsDescriptionFormatter",
						axIsIgnored: false,
						axHelp: "Description of current Channel action",
					},
				}
			}
		}
	},
		
	// MARK: images

	ChannelsImageFormatter:
	{
		nsClass: "GXDictionaryFormatter",
		gxDictionary: {
			0: "channels.none",
			1: "channels.swap",
			2: "channels.mono",
			3: "channels.duplicate.left",
			4: "channels.duplicate.right",
			5: "channels.kill.left",
			6: "channels.kill.right",
			7: "channels.invert.left",
			8: "channels.invert.right",
			9: "channels.subtract",
		}
	},

	// MARK: descriptions

	ChannelsDescriptionFormatter:
	{
		nsClass: "GXDictionaryFormatter",
		gxDictionary: {
			0: "<mediumWeight>No Change:</mediumWeight><foreColor2> Channels will not be adjusted.",
			1: "<mediumWeight>Swap:</mediumWeight><foreColor2> Left channel's audio is heard on the right channel, and vice versa.",
			2: "<mediumWeight>Mono:</mediumWeight><foreColor2> Blend left and right channels together.",
			3: "<mediumWeight>Copy Left:</mediumWeight><foreColor2> Left channel is copied to the right channel, overwriting its original contents.",
			4: "<mediumWeight>Copy Right:</mediumWeight><foreColor2> Right channel is copied to the left channel, overwriting its original contents.",
			5: "<mediumWeight>Kill Left:</mediumWeight><foreColor2> Left channel is removed.",
			6: "<mediumWeight>Kill Right:</mediumWeight><foreColor2> Right channel is removed.",
			7: "<mediumWeight>Invert Left:</mediumWeight><foreColor2> Left channel is inverted, changing the sign of all samples.",
			8: "<mediumWeight>Invert Right:</mediumWeight><foreColor2> Right channel is inverted, changing the sign of all samples.",
			9: "<mediumWeight>Subtract:</mediumWeight><foreColor2> The difference between channels is obtained by subtracting one from the other.",
		}
	},


})
